function CDX = set_mu(CDX, mu, dates)
% --------------------------------------------------------------------------------------------------
% Set mean of exponentially distributed jumps for common (mu) and idionsyncratic factors (mu*ai)
% --------------------------------------------------------------------------------------------------
% CDX       ... credit index structure (see 'all_steps_in_a_row.m')
% mu        ... desired mean of exponentially distributed jumps
% dates     ... dates for which to set parameters, if mu of length > 1
% --------------------------------------------------------------------------------------------------
% sample call: set_mu(CDX_NA_IG, 0.029)
% --------------------------------------------------------------------------------------------------

% Use fixed (i.e. time-homogenous parameter)
if (nargin == 2)
    % Set value for common factor
    CDX.AJD_common_factor.mu = mu;
    
    % Set value for individual CDS
    for i=1:length(CDX.portfolio)
        CDX.portfolio(i).AJD.mu = mu * CDX.portfolio(i).ai;
    end
    return
end

% Set value for common factor
[trash, used_pos_cdx, used_pos_params] = intersect_sorted(CDX.dates{1}, dates);
CDX.AJD_common_factor.mu(used_pos_cdx,:) = mu(used_pos_params,:);

% Set value for individual CDS
for i=1:length(CDX.portfolio)
    % Determine matching dates
    cds = CDX.portfolio(i);
    [trash, used_pos_cds, used_pos_params] = intersect_sorted(cds.dates{1}, dates);
    if (length(cds.ai) > 1)
        ai = cds.ai(used_pos_cds,:);
    else
        ai = cds.ai;
    end
    cds.AJD.mu(used_pos_cds,:) = ai .* mu(used_pos_params,:);
    CDX.portfolio(i) = cds;
    clear trash used_pos_cds used_pos_params
end